/* --------------------------------------------------------------
  Router.js 2019-06-07
  Gambio GmbH
  http://www.gambio.de
  Copyright (c) 2019 Gambio GmbH
  Released under the GNU General Public License (Version 2)
  [http://www.gnu.org/licenses/gpl-2.0.html]
  --------------------------------------------------------------*/


'use strict';

import CreateStyleModal from '../controllers/CreateStyleModal';
import CustomStylesModal from '../controllers/CustomStylesModal';
import DuplicateStyleModal from '../controllers/DuplicateStyleModal';
import EditStyleView from '../controllers/EditStyleView';
import MyStylesView from '../controllers/MyStylesView';
import UploadStyleModal from '../controllers/UploadStyleModal';
import UploadImageModal from '../controllers/UploadImageModal';
import PreviewImageModal from '../controllers/PreviewImageModal';

// Require all the controller files.
const controllers = {
	CreateStyleModal,
	CustomStylesModal,
	DuplicateStyleModal,
	EditStyleView,
	MyStylesView,
	UploadStyleModal,
	UploadImageModal,
	PreviewImageModal
};

/**
 * Will dynamically create the correct controller instance.
 *
 * http://stackoverflow.com/a/1608546
 *
 * @param {Function} constructor The class constructor.
 * @param {*[]} args Contains the constructor arguments.
 * @return {*} Returns new instance of the constructor.
 *
 * @private
 */
function _createController(constructor, args) {
	function Controller() {
		return constructor.apply(this, args);
	}
	
	Controller.prototype = constructor.prototype;
	return new Controller();
}

export default {
	/**
	 * Load the requested controller and execute the "initialize" method.
	 *
	 * Notice: the args object must define the properties in the same order as the constructor parameters.
	 *
	 * @param {String} controllerName The controller class name to be loaded.
	 * @param {*[]} args Optional ([]), array that contains the controller's parameters.
	 */
	load(controllerName, args = []) {
		StyleEdit.Validator.isString(controllerName);
		
		if (args !== undefined) {
			StyleEdit.Validator.isObject(args);
		}
		
		const instance = _createController(controllers[controllerName], args);
		
		instance.initialize();
	}
}
